%% ---- Simulation of nucleation dynamics on gTuRC ----
% Akanksha Thawani, April 2020
% Goal: make a simulation for nucleation kinetics from gTuRC
% Features to include:
% 1. Open to closed transition, here it matters what
% geometry to include - no lateral contacts prior to closure, or have some
% lateral contacts prior to closure
% 2. Bond energy between gamma- ab tubulin: change this factor
% 3. Polymerization dynamics: kon, GLong_TB, GLat_TB
% these will have to be optimized to match my experimental observations for
% growth speed

numsim = 1;

TbConc = 15*1e-6; %M, free GTP-tubulin concentration
kon = 1.3e6; %M^-1s^-1PF-1, on-rate constant; AT notes: my kon is > 0.5e6m will beed to find GLong, GLat based on that (200223)

GLong_TB = -7.2; %kBT, longitudinal bond free energy between ab/ab TB
GLat_TB = -6.5; %kBT, lateral bond free energy

GLong_gTB = 1.1*GLong_TB; % kBT, longitudinal bond free energy between g/abTB
                        % for now, set GLong_gTB equal to GLat_gTB %
                        % according to measurements 1.1-1.2x
kringclosure = 0.01; %s^-1
GgTuRCClosure = 10;
                    % kBT, energy penalty for conformational change
                    % this will have to be optimized, and also changed to
                    % look at the dependence on tubulin concentration

params = [TbConc,kon,GLong_TB,GLat_TB,GLong_gTB,GgTuRCClosure];

%%%% Terminating the simulation:
% simulation can be terminated either using time or number of events;
% if simTime = [] then events are used to terminate, otherwise time is used
simTime = 5*60; % s, total simulation time;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
output = {};
output.paramsnames = {'TbConc','kon','GLong_TB','GLat_TB','GLong_gTB','kringclosure','GgTuRCClosure','simTime'};
output.params = {TbConc,kon,GLong_TB,GLat_TB,GLong_gTB,kringclosure,GgTuRCClosure,simTime};
for i = 1:numsim
    [mtlenm,time,time_ringclose,mtstate_ringclose,time_visibleMTnucl]=simgTuRCnucleationdynamics(TbConc,kon,GLong_TB,GLat_TB,GLong_gTB,kringclosure,GgTuRCClosure,simTime);

    output(i).time_ringclose = time_ringclose;
    output(i).time_visibleMTnucl = time_visibleMTnucl;
    output(i).mtstate_ringclose = mtstate_ringclose;
    output(i).mtlenm = mtlenm;
    output(i).time = time;
    i
end

fname = [ num2str(TbConc*1e6) 'uMoutput_kclose0.01_Gclose' num2str(GgTuRCClosure) '_GlonggTB1.1fold.mat' ];

save(fname,'output')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
